/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.GuiNewSet;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.settings.ModSettings;
import xaero.map.WorldMap;
import xaero.map.element.MapElementMenuRenderer;
import xaero.map.element.MapElementRenderer;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiDropDown;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.gui.IDropDownCallback;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.Waypoint;
import xaero.map.mods.gui.WaypointMenuRenderContext;
import xaero.map.mods.gui.WaypointMenuRenderProvider;
import xaero.map.mods.gui.WaypointRenderer;

public class WaypointMenuRenderer
extends MapElementMenuRenderer<Waypoint, WaypointMenuRenderContext> {
    private final WaypointRenderer renderer;

    public WaypointMenuRenderer(WaypointMenuRenderContext context, WaypointMenuRenderProvider provider, WaypointRenderer renderer) {
        super(context, provider);
        this.renderer = renderer;
    }

    public void onMapInit(final GuiMap screen, List<GuiDropDown> dropdowns, Minecraft mc, final int width, final int height, final WaypointWorld waypointWorld, final IXaeroMinimap modMain, final XaeroMinimapSession minimapSession) {
        GuiDropDown setsDropdown;
        super.onMapInit(screen, dropdowns, mc, width, height);
        final boolean canCreate = SupportMods.xaeroMinimap.compatibilityVersion >= 6;
        final GuiWaypointSets sets = waypointWorld != null ? new GuiWaypointSets(canCreate, waypointWorld) : null;
        IDropDownCallback setsDropdownCallback = null;
        if (sets != null) {
            setsDropdownCallback = new IDropDownCallback(){

                @Override
                public boolean onSelected(GuiDropDown menu, int selected) {
                    if (canCreate && selected == menu.size() - 1) {
                        GuiNewSet guiNewSet = new GuiNewSet(modMain, minimapSession, (GuiScreen)screen, (GuiScreen)screen, waypointWorld);
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)guiNewSet);
                        return false;
                    }
                    sets.setCurrentSet(selected);
                    waypointWorld.setCurrent(sets.getCurrentSetKey());
                    minimapSession.getWaypointsManager().updateWaypoints();
                    try {
                        modMain.getSettings().saveWaypoints(waypointWorld);
                    }
                    catch (IOException e) {
                        WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
                    }
                    return true;
                }
            };
        }
        GuiDropDown guiDropDown = setsDropdown = sets == null ? null : new GuiDropDown(sets.getOptions(), width - 173, height - 56, 151, sets.getCurrentSet(), true, setsDropdownCallback, true);
        if (setsDropdown != null) {
            dropdowns.add(setsDropdown);
        }
        TextComponentTranslation fullWaypointMenuTooltipText = new TextComponentTranslation("gui.xaero_box_full_waypoints_menu", new Object[]{new TextComponentString(Misc.getKeyName(ModSettings.keyWaypoints)).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN))});
        screen.addGuiButton(new GuiTexturedButton(width - 173, height - 20, 20, 20, 229, 0, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

            @Override
            public void accept(GuiButton b) {
                WaypointMenuRenderer.this.onFullMenuButton(b, screen);
            }
        }, new CursorBox((ITextComponent)fullWaypointMenuTooltipText, true)));
        screen.addGuiButton(new GuiTexturedButton(width - 153, height - 20, 20, 20, WorldMap.settings.onlyCurrentMapWaypoints ? 213 : 229, 16, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

            @Override
            public void accept(GuiButton b) {
                WaypointMenuRenderer.this.onCurrentMapWaypointsButton(b, screen, width, height);
            }
        }, new CursorBox(WorldMap.settings.onlyCurrentMapWaypoints ? "gui.xaero_box_only_current_map_waypoints" : "gui.xaero_box_waypoints_selected_by_minimap", null, true)));
        screen.addGuiButton(new GuiTexturedButton(width - 133, height - 20, 20, 20, WorldMap.settings.renderWaypoints ? 229 : 213, 48, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

            @Override
            public void accept(GuiButton b) {
                WaypointMenuRenderer.this.onRenderWaypointsButton(screen, width, height);
            }
        }, new CursorBox((ITextComponent)new TextComponentTranslation(WorldMap.settings.renderWaypoints ? "gui.xaero_box_rendering_waypoints" : "gui.xaero_box_not_rendering_waypoints", new Object[]{new TextComponentString(Misc.getKeyName(ModSettings.keyToggleMapWaypoints)).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN))}), true)));
        screen.addGuiButton(new GuiTexturedButton(width - 113, height - 20, 20, 20, !modMain.getSettings().renderAllSets ? 81 : 97, 16, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

            @Override
            public void accept(GuiButton b) {
                WaypointMenuRenderer.this.onRenderAllSetsButton(b, screen, width, height);
            }
        }, new CursorBox((ITextComponent)new TextComponentTranslation(!modMain.getSettings().renderAllSets ? "gui.xaero_box_rendering_current_set" : "gui.xaero_box_rendering_all_sets", new Object[]{new TextComponentString(Misc.getKeyName(ModSettings.keyAllSets)).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GREEN))}), true)));
        screen.addGuiButton(new GuiTexturedButton(width - 93, height - 20, 20, 20, WorldMap.settings.showDisabledWaypoints ? 133 : 149, 16, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

            @Override
            public void accept(GuiButton b) {
                WaypointMenuRenderer.this.onShowDisabledButton(b, screen, width, height);
            }
        }, new CursorBox(WorldMap.settings.showDisabledWaypoints ? "gui.xaero_box_showing_disabled" : "gui.xaero_box_hiding_disabled", null, true)));
        screen.addGuiButton(new GuiTexturedButton(width - 73, height - 20, 20, 20, WorldMap.settings.closeWaypointsWhenHopping ? 181 : 197, 16, 16, 16, WorldMap.guiTextures, new Consumer<GuiButton>(){

            @Override
            public void accept(GuiButton b) {
                WaypointMenuRenderer.this.onCloseMenuWhenHoppingButton(b, screen, width, height);
            }
        }, new CursorBox(WorldMap.settings.closeWaypointsWhenHopping ? "gui.xaero_box_closing_menu_when_hopping" : "gui.xaero_box_not_closing_menu_when_hopping", null, true)));
    }

    public void onRenderWaypointsButton(GuiMap screen, int width, int height) {
        WorldMap.settings.renderWaypoints = !WorldMap.settings.renderWaypoints;
        try {
            WorldMap.settings.saveSettings();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        screen.func_146280_a(this.mc, width, height);
    }

    private void onFullMenuButton(GuiButton b, GuiMap screen) {
        SupportMods.xaeroMinimap.openWaypointsMenu(this.mc, screen);
    }

    private void onRenderAllSetsButton(GuiButton b, GuiMap screen, int width, int height) {
        SupportMods.xaeroMinimap.handleMinimapKeyBinding(ModSettings.keyAllSets, screen);
    }

    private void onShowDisabledButton(GuiButton b, GuiMap screen, int width, int height) {
        WorldMap.settings.showDisabledWaypoints = !WorldMap.settings.showDisabledWaypoints;
        try {
            WorldMap.settings.saveSettings();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        screen.func_146280_a(this.mc, width, height);
    }

    private void onCloseMenuWhenHoppingButton(GuiButton b, GuiMap screen, int width, int height) {
        WorldMap.settings.closeWaypointsWhenHopping = !WorldMap.settings.closeWaypointsWhenHopping;
        try {
            WorldMap.settings.saveSettings();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        screen.func_146280_a(this.mc, width, height);
    }

    private void onCurrentMapWaypointsButton(GuiButton b, GuiMap screen, int width, int height) {
        WorldMap.settings.onlyCurrentMapWaypoints = !WorldMap.settings.onlyCurrentMapWaypoints;
        try {
            WorldMap.settings.saveSettings();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        screen.func_146280_a(this.mc, width, height);
    }

    @Override
    public void renderInMenu(Waypoint element, GuiScreen gui, int mouseX, int mouseY, double scale, boolean enabled, boolean hovered, Minecraft mc, boolean pressed, int textX) {
        Waypoint w = element;
        boolean disabled = w.isDisabled();
        boolean temporary = w.isTemporary();
        int type = w.getType();
        int color = w.getColor();
        String symbol = w.getSymbol();
        GlStateManager.func_179109_b((float)-4.0f, (float)-4.0f, (float)0.0f);
        GlStateManager.func_179147_l();
        if (type == 1) {
            Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)color);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Waypoint.minimapTextures);
            GlStateManager.func_179131_c((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            gui.func_73729_b(1, 1, 0, 78, 9, 9);
            GlStateManager.func_179131_c((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            gui.func_73729_b(0, 0, 0, 78, 9, 9);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            GlStateManager.func_179090_x();
            Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)color);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (type != 1) {
            mc.field_71466_p.func_175063_a(symbol, (float)(5 - mc.field_71466_p.func_78256_a(symbol) / 2), 1.0f, -1);
        }
        GlStateManager.func_179147_l();
        int infoIconOffset = 10;
        if (disabled) {
            GlStateManager.func_179098_w();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(WorldMap.guiTextures);
            gui.func_73729_b(textX - 1 - infoIconOffset, 0, 173, 16, 8, 8);
            infoIconOffset += 10;
        }
        if (temporary) {
            GlStateManager.func_179098_w();
            GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(WorldMap.guiTextures);
            gui.func_73729_b(textX - 1 - infoIconOffset, 0, 165, 16, 8, 8);
            infoIconOffset += 10;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public int menuStartPos(int height) {
        return height - 59;
    }

    @Override
    public int menuSearchPadding() {
        return 14;
    }

    @Override
    protected String getFilterPlaceholder() {
        return "gui.xaero_filter_waypoints_by_name";
    }

    @Override
    protected MapElementRenderer<? super Waypoint, ?, ?> getRenderer(Waypoint element) {
        return this.renderer;
    }

    @Override
    protected void beforeFiltering() {
    }

    @Override
    protected void beforeMenuRender() {
    }

    @Override
    protected void afterMenuRender() {
    }
}

